#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <errno.h>
#include <netinet/in.h>
#include <string.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>

#define DEBUG

#include "pogohash.inc"

#define MYPORT      3000
#define BACKLOG     1000
#define MAXDATASIZE 512

int main()
{
  int servSock, cliProc;
  socklen_t sin_size;
  uint8_t buf[MAXDATASIZE];
  struct sockaddr_in my_addr, income_addr;

#ifdef DEBUG
  fprintf(stdout, "PogoHash TCP/IP server\n");
  fprintf(stdout, "----------------------\n");
  fprintf(stdout, "\n");
#endif

  my_addr.sin_family = AF_INET;
  my_addr.sin_port = htons(MYPORT);
  my_addr.sin_addr.s_addr = htonl(INADDR_ANY);

  if ((servSock = socket(AF_INET, SOCK_STREAM, 0)) != -1)
  {
    if (bind(servSock, 
             (struct sockaddr *)&my_addr, sizeof(struct sockaddr)) != -1)
    {
      int connection_count = 0;
#ifdef DEBUG
      fprintf(stdout, ":: init()\n");
#endif
      POGO_init();

      while (1)
      {
        listen(servSock, BACKLOG);

        sin_size = sizeof(struct sockaddr_in);
        if ((cliProc = 
              accept(servSock, 
                     (struct sockaddr *)&income_addr, &sin_size)) != -1)
        {
          int cnt;

          connection_count++;
#ifdef DEBUG
          fprintf(stdout, "[%4d]\n", connection_count);
#endif

          cnt = recv(cliProc, buf, MAXDATASIZE, 0);
          if (cnt != -1)
          {
            unsigned long result;
            int i;

#ifdef DEBUG
            for (i=0; i<cnt; i++)
              fprintf(stdout, "%02x ", (buf[i] & 0xff));
            fprintf(stdout, "len=%2d\n", cnt);
#endif
            result = Hash(buf, cnt);
#ifdef DEBUG
            printf("hash: 0x%08lx\n", result);
#endif

            // send the data (platform specific, little endian on x86)
            send(cliProc, &result, sizeof(result), 0);
          }

          close(cliProc);
        }
      }

      fprintf(stdout, ":: quit()\n");
      POGO_quit();
    }

    close(servSock);
  }

  return 0;
}
