#include <sys/socket.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>

int main(int argc, char *argv[])
{
  int s;
  struct sockaddr_in addr; 

  memset(&addr, '0', sizeof(addr)); 
  addr.sin_family = AF_INET;
  addr.sin_port = htons(1500); 
  inet_pton(AF_INET, "127.0.0.1", &addr.sin_addr);

  if ((s = socket(AF_INET, SOCK_STREAM, 0)) != -1)
  {
    if (connect(s, (struct sockaddr *)&addr, sizeof(addr)) != -1)
    {
      unsigned char buf[24] = { 0 };
      unsigned char res[8]  = { 0 };
      unsigned long long hash;
      int i;

      // send and receive hash back 
      write(s, buf, sizeof(buf));
      read(s, res, 8);
      close(s);

      // server responds with uint64_t little endian
      hash = *((unsigned long *)res);

      // display something showing the request and result
      for (i=0;i<sizeof(buf); i++)
        printf("0x%02x ", buf[i]);
      printf("len = %d\r\n", sizeof(buf));
      printf("0x%08lx\r\n", hash);
    } 
  }
}
